/*
 * Decompiled with CFR 0.152.
 */
package com.roguewave.chart.core.v2_1;

import com.roguewave.chart.core.v2_1.graphics.Canvas3D;
import com.roguewave.chart.core.v2_1.graphics.ClickableDrawable;
import com.roguewave.chart.core.v2_1.graphics.Line3D;
import com.roguewave.chart.core.v2_1.graphics.Markings3D;
import com.roguewave.chart.core.v2_1.graphics.Markings3DDrawable;
import com.roguewave.chart.core.v2_1.graphics.Point3D;
import com.roguewave.chart.core.v2_1.graphics.Polygon3D;
import com.roguewave.chart.core.v2_1.graphics.SortTreeNode;
import java.awt.Color;
import java.io.Serializable;
import java.util.Vector;

public class ChartPart
implements Serializable {
    private SortTreeNode stn_ = null;
    private Vector twoDPolygons_ = new Vector();
    private Vector twoDClickables_ = new Vector();
    private Vector twoDLines_ = new Vector();

    protected void setSortTree(SortTreeNode stn) {
        this.stn_ = stn;
    }

    public SortTreeNode getSortTree() {
        return this.stn_;
    }

    public Vector get2DPolygons() {
        return this.twoDPolygons_;
    }

    public Vector get2DClickables() {
        return this.twoDClickables_;
    }

    protected void add3DTo(Canvas3D canvas) {
        this.stn_.addTo(canvas);
    }

    public void add2DTo(Canvas3D canvas) {
        for (int i = 0; i < this.twoDPolygons_.size(); ++i) {
            Polygon3D[] polygons = (Polygon3D[])this.twoDPolygons_.elementAt(i);
            for (int j = 0; j < polygons.length; ++j) {
                canvas.addPolygon(polygons[j].zeroZ());
            }
        }
        for (int i = 0; i < this.twoDClickables_.size(); ++i) {
            canvas.addClickable((ClickableDrawable)this.twoDClickables_.elementAt(i));
        }
        Vector<Line3D> z0Lines = new Vector<Line3D>();
        for (int i = 0; i < this.twoDLines_.size(); ++i) {
            Vector lines = (Vector)this.twoDLines_.elementAt(i);
            for (int j = 0; j < lines.size(); ++j) {
                Line3D line = (Line3D)lines.elementAt(j);
                z0Lines.addElement(line.zeroZ());
            }
        }
        Point3D[] textTestPoints = new Point3D[]{new Point3D(0.0, 0.0, 0.0), new Point3D(0.0, 1.0, 0.0), new Point3D(1.0, 0.0, 0.0)};
        Markings3D text = new Markings3D(textTestPoints, z0Lines);
        Markings3DDrawable textDrawable = new Markings3DDrawable(text, Color.black);
        canvas.addDrawable(textDrawable);
    }

    protected void add2DPolygons(Polygon3D[] polygons) {
        this.twoDPolygons_.addElement(polygons);
    }

    protected void add2DClickable(ClickableDrawable clickable) {
        this.twoDClickables_.addElement(clickable);
    }

    protected void add2DLines(Vector lines) {
        this.twoDLines_.addElement(lines);
    }
}

